%% Filtro Low-pass

T = 5;         % Tempo  di simulazione (s)
dt = 0.01;     % Passo temporale (s)
t = 0:dt:T;    % Asse temporale

%  Esempio di errore di posizione variabile nel tempo 
e_p = sin(2*pi*0.2*t);  

a0 = 2;        % Accelerazione massima (m/s^2)
v0 = 1;        % Velocità massima (m/s)


v_des = zeros(size(e_p));

% Calcolo della velocità  
for i = 1:length(e_p)
    v_des(i) = min([a0 * t(i), v0, sqrt(2 * a0 * abs(e_p(i)))]) * sign(e_p(i));
end

% Calcolo dell'accelerazione grezza 
a_des_raw = [0, diff(v_des) / dt]; 

% Applicazione del filtro passa-basso per smussare l'accelerazione
tau = 0.2; % Costante di tempo del filtro
a_des_smooth = zeros(size(a_des_raw)); % Pre-allocazione

for i = 2:length(t)
    a_des_smooth(i) = (dt / (tau + dt)) * a_des_raw(i) + ...
                      (tau / (tau + dt)) * a_des_smooth(i-1);
end

% Plot dei risultati
figure;

% Errore di posizione
subplot(4,1,1);
plot(t, e_p, 'k', 'LineWidth', 1.5);
xlabel('Tempo (s)'); ylabel('Errore Posizione');
title('Errore di Posizione nel Tempo'); grid on;

% Velocità desiderata
subplot(4,1,2);
plot(t, v_des, 'b', 'LineWidth', 1.5);
xlabel('Tempo (s)'); ylabel('Velocità (m/s)');
title('Velocità Desiderata (Profilo Trapezoidale)'); grid on;

% Accelerazione grezza
subplot(4,1,3);
plot(t, a_des_raw, 'r', 'LineWidth', 1.5);
xlabel('Tempo (s)'); ylabel('Accelerazione (m/s^2)');
title('Accelerazione Grezza'); grid on;

% Accelerazione filtrata 
subplot(4,1,4);
plot(t, a_des_smooth, 'g', 'LineWidth', 1.5);
xlabel('Tempo (s)'); ylabel('Accelerazione (m/s^2)');
title('Accelerazione Filtrata'); grid on;
